#include "a_star.h"
#include <iostream>
#include <conio.h>

int main(void)
{
	// Example One, Simple!
	Astar star(64,64,NULL); // Make a 64x64 grid, allocate grid itself in the astar object.
	star.SetStart( star.Convert_xy_to_i(5,7) );
	star.SetEnd( star.Convert_xy_to_i(13,55) );
	star.SetWall( star.Convert_xy_to_i(8,7) );
	star.SetWall( star.Convert_xy_to_i(8,8) );
	bool solutionExists = star.LetsGo( star.m_SolVec, true, false );  // Never need to "fix false step anymore"

	for (int z = 0; z < (int)star.m_SolVec.size(); ++z) // solVec contains solution path if one exists.
	{
		int x;
		int y;
		star.Convert_i_to_xy(star.m_SolVec[z], x, y);
		std::cout << star.m_SolVec[z] << ":  (" << x << ", " << y << ")." << std::endl;
	}
	star.DebugSendMapToFile( std::string("mapFile.txt"), ' ', 's', 'e', '*', true, star.m_SolVec);

	// Example Two, Load map from file.
	Astar star2( std::string("64x64.txt"), ' ', 's', 'e', '*');
	star2.SetStart(177);
	star2.SetEnd(65);
	star2.SecureBorders(); // make a **** perimeter around edges of map.
	star2.LetsGo( star2.m_SolVec, true, false );  // Never need to "fix false step anymore"
	// Send solution to text file
	star2.DebugSendMapToFile( std::string("mapFile2.txt"), ' ', 's', 'e', '*', true, star2.m_SolVec);

	std::cout << "Press any key to exit program." << std::endl;
	getch();
	return 0;
}

